# ------------------------------------------------------------------------
#  In next line you must define the path to your Borlands C++.

!ifndef BC501
     BC501=c:\progra~2\progra~1\Cpp\       # BCC directory
!endif


.phony: all All goal Goal total Total
#############################################################################################
#
#    OBJ Directories
#
#############################################################################################
!ifdef IDA51
     IDADIR=$(IDA)51\\
     F=OBJ\OBJ51\\
!endif

!ifdef IDA52
     IDADIR=$(IDA)52\\
     F=OBJ\OBJ52\\
!endif

!ifdef IDA53
     IDADIR=$(IDA)53\\
     F=OBJ\OBJ53\\
!endif

!ifdef IDA54
     IDADIR=$(IDA)54\\
     F=OBJ\OBJ54\\
!endif

!ifdef IDA55
     IDADIR=$(IDA)55\\
     F=OBJ\OBJ55\\
!endif


#############################################################################################
#
#    if -DDEBUG  (set debug switches)
#
#############################################################################################
!ifdef DEBUG        #only for Borland
     CCDEBUG=/v
     CCNOOPT=-O-
!endif


#############################################################################################
#
#    include and help directories are common for all platforms and compilers:
#
#############################################################################################
RS   =$(IDADIR)bin\             # host utilities directory
I    =$(IDADIR)include\\
H    =$(IDADIR)help\             # help directory
HS   =.hls                       # help source
HH   =.hhp                       # help headers


#############################################################################
#
#    Borland C++ for NT (Win32)
#
#############################################################################

#Paths
IMPLIB    =$(BC501)bin\implib.exe                                # implib executable name
ASM       =tasm32.exe                                            # assembler (in PATH)
CC        =bcc32.exe                                             # C++ compiler (in PATH)

#Flags
CFLAGS    =+$(IDADIR)w32bor.cfg $(_CFLAGS) $(CCDEBUG) $(CCNOOPT)    # default compiler flags
AFLAGS    =/D__FLAT__ /t/ml/m5$(_AFLAGS)                             # default assembler flags
OUTSW     =-n -e                                                     # outfile name switch for one-line linker
OUTDLL    =/Tpd                                                      # output is DLL switch

!ifdef BASE
NT_BSW    =/b=$(BASE)
!endif

LDFLAGS   =$(NT_BSW) /Gn
LINKER    =ilink32.exe $(LDFLAGS) $(CCDEBUG)                     # indirect file linker
CCL       =$(RS)ld _b _l$(CC) $(CFLAGS) $(_LDFLAGS)              # one-line linker
LINKSYS_EXE=                                                     # target link system for executable
LINKSYS   =                                                      # target link system
C_STARTUP=c0x32                                                  # indirect linker: C startup file
C_IMP     =import32                                              # import library
#C_LIB     =$(C_IMP) $(L)noeh32 cw32                             # indirect linker: default C library
C_LIB     =$(C_IMP) cw32mt                                       # indirect linker: default C library
OVRON     =                                                      # 16bit: following files overlayed
OVROFF    =                                                      # 16bit: following files not overlayed
ORDINALS  =                                                      # import functions by ordinals
L         =$(IDADIR)lib\                                            # libraries directory

B         =.exe                                                  # exe file extension
BS        =.exe                                                  # host utility extension
MAP       =.mpb                                                  # map file extension
T         =.arb                                                  # library flag file extension
IDP       =.w32                                                  # IDP extension
LDR       =.ldw                                                  # LDR extension
PLUGIN    =.plw                                                  # PLUGIN extension
DLLEXT    =.wll
# -c case sensitive
# -C clear state before linking
# -s detailed map of segments
# -m detailed map of publics
# -r verbose

LINKOPTS_EXE=$(CCDEBUG) -m -s -c -C -r $(ORDINALS) 
LINKOPTS=$(OUTDLL) $(LINKOPTS_EXE)
O         =.obj                                                  # object file extension
A         =.lib                                                  # library file extension
API       =.api                                                  # API definition file extension
DEF       =.df2                                                  # DEF file extension

!if  !$d(NORTL)
IDPSTUB   =$(BC501)Lib\c0d32                                     # STUB file for IDPs
LDRSTUB   =$(BC501)Lib\c0d32                                     # STUB file for LDRs
IDPSLIB   =$(C_LIB)                                              # system libraries for IDPs
!else
IDPSTUB   =$(L)modstart                                          # STUB file for IDPs
LDRSTUB   =$(L)modstart                                          # STUB file for LDRs
IDPSLIB   =$(C_IMP)                                              # system libraries for IDPs
!endif

AR        =$(RS)ar$(BS) _a _e$(T) "_ltlib /C/E/P64" ruv          # librarian
APISW     =-swin -i$(R)ida.imp -n
#############################################################################

!if 0		# this is for makedep
F=
CFLAGS=+$(IDADIR)dosbor.cfg
!endif

HC=$(RS)hc$(BS)                    # Help Compiler
#RM=$(R)rm                          # File Remover

IDALIB=$(L)ida$(A)

HLIB=$(H)_ida.hlp

# IDC directory

RI=$(R)idc\                        # IDC directory

########################################################################

MAKEFLAGS=$(WD) -U__MSDOS__ -D__NT__

########################################################################
# assume Borland

!ifndef CONLY
CONLY=-c
!endif

.cpp$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.c$(O):
        $(CC) $(CFLAGS) $(CONLY) {$< }
.asm$(O):
        $(ASM) $(AFLAGS) $*,$(F)$*


.hls.hhp:
	$(HC) -t $(HLIB) -i$@ $?
$(API)$(DEF):
	$(RS)api2df$(BS) $(APISW) $? $@
$(DEF)$(A):
	$(IMPLIB) $@ temp.def >nul
